import csv, sys, ntpath

print "\n\n#### EEG trigger converter ####"
print "\nThis simple script will take two input files and convert triggers."

#Determine that we have enough arguments
if len(sys.argv) < 3:
	print "\n\nERROR: Please specify a CSV input file, followed by VMRK file."
	sys.exit()

#Make sure the files are correct first
if str(sys.argv[1]).endswith('.csv') and str(sys.argv[2]).endswith('.vmrk'):
	print "Starting..."

	csvfile = sys.argv[1]
	vmrkfile = sys.argv[2]
	vmrkfilename = ntpath.basename(vmrkfile)

	print "Reading csv file"
	#First read both files as a list
	with open(csvfile, 'rb') as f:
	    reader = csv.reader(f)
	    csv_data = list(reader)

	print "Reading vmrk file"
	with open(vmrkfile, 'rb') as f:
	    reader = csv.reader(f)
	    vmrk_data = list(reader)
	
	vmrkcounter = 0 #Start pointer for vmrkfile to scan
	csvstart = 1 #Start pointer for csv
	triggers_per_trial = 3 #Triggers per trial


	print "\nProcessing CSV and translating...\n\n"

	#Start a loop through the entire trial CSV
	for i in range(csvstart,len(csv_data)):
		trial_triggers_found = 0

		#While we haven't found 3 triggers for the trial and are not at the end...
		while trial_triggers_found < triggers_per_trial and vmrkcounter < len(vmrk_data):
			#Grab a stimulus trigger and increase count

			print ("."),

			if len(vmrk_data[vmrkcounter])>0 and "Stimulus" in vmrk_data[vmrkcounter][0]:
				trial_triggers_found = trial_triggers_found + 1

				#Pull out the data we want to check for readability
				trigger = vmrk_data[vmrkcounter][1]
				change = csv_data[i][1]
				key_resp = csv_data[i][2]

				#Now run some checks

				#First batch conditions
				#if trigger == "S152" and change == "0":
				#	vmrk_data[vmrkcounter][1] = "S103"
				#elif trigger == "S152" and change == "1":
				#	vmrk_data[vmrkcounter][1] = "S102"
				#elif trigger == "S248" and change == "0":
				#	vmrk_data[vmrkcounter][1] = "S203"
				#elif trigger == "S248" and change == "1":
				#	vmrk_data[vmrkcounter][1] = "S202"	
				#elif trigger == "S 56" and change == "0" and key_resp == "0":
				#	vmrk_data[vmrkcounter][1] = "S 36"	
				#elif trigger == "S 50" and change == "0" and key_resp == "1":
				#	vmrk_data[vmrkcounter][1] = "S 35"	
				#elif trigger == "S 42" and change == "1" and key_resp == "0":
				#	vmrk_data[vmrkcounter][1] = "S 26"	
				#elif trigger == "S 40" and change == "1" and key_resp == "1":
				#	vmrk_data[vmrkcounter][1] = "S 25"											

				#New conditions for 14 and 15
				if trigger == "S 98" and change == "0":
					vmrk_data[vmrkcounter][1] = "S103"
				elif trigger == "S 98" and change == "1":
					vmrk_data[vmrkcounter][1] = "S102"
				elif trigger == "S202" and change == "0":
					vmrk_data[vmrkcounter][1] = "S203"
				elif trigger == "S202" and change == "1":
					vmrk_data[vmrkcounter][1] = "S202"	
				elif trigger == "S 32" and change == "0" and key_resp == "0":
					vmrk_data[vmrkcounter][1] = "S 36"	
				elif trigger == "S 34" and change == "0" and key_resp == "1":
					vmrk_data[vmrkcounter][1] = "S 35"	
				elif trigger == "S 26" and change == "1" and key_resp == "0":
					vmrk_data[vmrkcounter][1] = "S 26"	
				elif trigger == "S 24" and change == "1" and key_resp == "1":
					vmrk_data[vmrkcounter][1] = "S 25"	

			#Increase the vmrk counter
			vmrkcounter = vmrkcounter + 1


	#Fix the comma in type fields
	vmrk_data[10][0] = str(vmrk_data[10][0]).translate(None, '"')

	#Save fixed vmrk file
	with open('output/' + vmrkfilename, 'wb') as f:
	    a = csv.writer(f, delimiter=',')
	    a.writerows(vmrk_data)	

	print "\n\n### EXPORT COMPLETE - SEE OUTPUT DIRECTORY FOR VMRK ###"
	sys.exit()
else:
	print "\n\nERROR: Please specify a valid CSV input file first, followed by VMRK file."
	sys.exit()